import { Component, OnInit } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../store';
import { 
  ENABLE_CONCEPT_CARD_VIEW,
  DISABLE_CONCEPT_CARD_VIEW,
  ENABLE_CONCEPT_NODE_VIEW,
  DISABLE_CONCEPT_NODE_VIEW,
  FOCUS_ON,
  CHANGE_USER_ROLE,
} from '../../actions';
import {
RESEARCHER_ROLE,
TERMINOLOGIST_ROLE,
} from '../../constants';
import { SystemServices } from '../../services/system-services';
import { ConceptServices } from '../../services/concept-services';
@Component({
  selector: 'app-top-navigation',
  templateUrl: './top-navigation.component.html',
  styleUrls: ['./top-navigation.component.scss']
})
export class TopNavigationComponent implements OnInit {
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    private systemService: SystemServices,
    private conceptService: ConceptServices) { }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  isExpanded(type) {
    switch (type) {
      case 'conceptCardIcon':
        return this.canViewConceptCard() ? 'expanded' : 'not expanded';
      default:
        return false;
    }
  }

  canViewConceptCard() {
    return this.getState().conceptCard.canViewConceptCard;
  }

  switchConceptCard() {
    // if (this.canViewConceptCard()) {
    //   //this.systemService.focusOn(null);
    //   //this.systemService.focusOn('conceptCardNavIcon');
    //   // this.ngRedux.dispatch({
    //   //   type: DISABLE_CONCEPT_CARD_VIEW
    //   // });
    //   // this.systemService.focusOn('conceptCardNavIcon', 2000);
    // } else {
      this.ngRedux.dispatch({
        type: ENABLE_CONCEPT_CARD_VIEW
      });
      if (this.conceptService.conceptCardPopulated()) {
        this.systemService.focusOn('conceptCardTitle');
      } else {
        this.systemService.focusOn('conceptCardPopulating');
      }
    // }
  }

  canViewNode() {
    return this.getState().conceptNode.canViewNode;
  }

  switchConceptNodeView() {
    if (this.canViewNode()) {
      this.ngRedux.dispatch({
        type: DISABLE_CONCEPT_NODE_VIEW
      });
    } else {
      this.ngRedux.dispatch({
        type: ENABLE_CONCEPT_NODE_VIEW
      });
    }
  }

  onChange(value) {
    this.ngRedux.dispatch({
      type: CHANGE_USER_ROLE,
      payload: value
    })
  }
}
